import java.io.File;
import java.util.List;
import java.io.FileReader;
import java.io.BufferedReader;
import org.slf4j.LoggerFactory;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetTagLocalServiceUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLFileEntryLocalServiceUtil;


final logger = LoggerFactory.getLogger("vic.gov.au.ses.assigntags_document_script")
//Below fileEntry ID needs to be changed as per source CSV files
readFromFileEntryId = 17924962;
final delimiter=",";
final companyId=CompanyThreadLocal.getCompanyId();
final stagingHubGroup= GroupLocalServiceUtil.fetchFriendlyURLGroup(companyId,"/hub-staging");

	try {
		file=DLFileEntryLocalServiceUtil.getFile(readFromFileEntryId,"1.0",false);
		out.println("Starting tag assignment process");
		logger.info("Starting tag assignment process");
		fr = new FileReader(file);
		br = new BufferedReader(fr);
		String line = "";
		String[] tempArr;
		totalRecordsProcessed=0;
		totalRecordsTagAssigned=0;
		totalLiveFileEntryNotFound=0;
		totalFileNotFoundByName=0;
		totalAssetEntryNotFound=0;
		totalRecordsWithFileNameMissing=0;
		
		//Read CSV file line by line
		while((line = br.readLine()) != null) {
		
		//Splits line to extract URL & Tag
		tempArr = line.split(delimiter);
		
		if(tempArr.length>1){
			url=tempArr[0];
			assigningTagName=tempArr[1];
			//out.println(url+ ":"+assigningTagName);
			//logger.info(url+ ":"+assigningTagName);
			
			//Splits URL to extract groupID,folderId and fileName
			urlSplits=tempArr[0].split("/");
			
			if(urlSplits.length>5 &&urlSplits.length<=7){
				groupId =Long.valueOf(urlSplits[urlSplits.length-3]);
				folderId =Long.valueOf(urlSplits[urlSplits.length-2]);
				fileName=urlSplits[urlSplits.length-1];
				//logger.info("Tag assignment process for file::"+fileName);
				if(Validator.isNotNull(fileName) && fileName!=""){
				  try{
						liveFileEntry=DLFileEntryLocalServiceUtil.fetchFileEntryByFileName(groupId, folderId, fileName);
						if(Validator.isNotNull(liveFileEntry)){
							stagingFileEntry=DLFileEntryLocalServiceUtil.fetchDLFileEntryByUuidAndGroupId(liveFileEntry.getUuid(), stagingHubGroup.getGroupId());
							try{
							    assetEntry=null;
								if(Validator.isNotNull(stagingFileEntry)){
								  assetEntry=AssetEntryLocalServiceUtil.getEntry(DLFileEntry.class.getName(),stagingFileEntry.getPrimaryKey());
								}else{
								  assetEntry=AssetEntryLocalServiceUtil.getEntry(DLFileEntry.class.getName(),liveFileEntry.getPrimaryKey());
								}
								
								if(Validator.isNotNull(assetEntry)){
									List<String> tagNames = new ArrayList<String>();
									assetEntry.getTags().forEach({tagEntry->
											if(!tagEntry.getName().equalsIgnoreCase("archive") || !tagEntry.getName().equalsIgnoreCase("keep") || !tagEntry.getName().equalsIgnoreCase("delete")){
												tagNames.add(tagEntry.getName());
											}
									});
									tagNames.add(assigningTagName.toLowerCase());
									String[] assigningTags = tagNames.toArray(new String[tagNames.size()]);
									try{
										//Update entry with Tags
										AssetEntryLocalServiceUtil.updateEntry(assetEntry.getUserId(), assetEntry.getGroupId(), assetEntry.getClassName(), assetEntry.getClassPK(),assetEntry.getCategoryIds(),assigningTags);
										totalRecordsTagAssigned++;
									}catch(Exception e) {
										out.println("Error in assigning tag to file::"+fileName+"::error:"+e.getMessage());
										logger.error("Error in assigning tag to file::"+fileName+"::error:"+e.getMessage());
									}
								}else{
									out.println("Asset entry not found for::"+fileName);
									logger.info("Asset entry not found for::"+fileName);
									totalAssetEntryNotFound++;
								}
							}catch(Exception e){
								out.println("Error in fetching assetentry of file::"+fileName+"::error:"+e.getMessage());
								logger.error("Error in fetching assetentry of file::"+fileName+"::error:"+e.getMessage());
							} 
										
			
						}else{
						   //out.println("Live file entry not found for::"+fileName);
						   //logger.info("Live file entry not found for::"+fileName);
						   totalLiveFileEntryNotFound++;
						}
					
				  }catch(Exception e){
							out.println("Error in fetching file::"+fileName+"::error:"+e.getMessage());
							logger.error("Error in fetching file::"+fileName+"::error:"+e.getMessage());
				  }
				}else{
					//out.println("FileName is null/empty for record::"+tempArr[0]);
					//logger.info("FileName is null/empty for record::"+tempArr[0]);
					totalRecordsWithFileNameMissing++;
				}
				
				
			}else{
				//out.println("Issue with URL::"+tempArr[0]);
				//logger.info("Issue with URL::"+tempArr[0]);
				totalRecordsWithFileNameMissing++;
			
			}
			out.println();
			totalRecordsProcessed++;
		}
		}
		out.println("Total records processed::"+totalRecordsProcessed);
		out.println("Total records assigned with Tags::"+totalRecordsTagAssigned);
		out.println("Total records with filename missing::"+totalRecordsWithFileNameMissing);
		out.println("Total records with Live file entry not found::"+totalLiveFileEntryNotFound);
		out.println("Total records with AssetEntry not found::"+totalAssetEntryNotFound);
		logger.info("Total records processed::"+totalRecordsProcessed);
		logger.info("Total records assigned with Tags::"+totalRecordsTagAssigned);
		logger.info("Total records with filename missing::"+totalRecordsWithFileNameMissing);
		logger.info("Total records with Live file entry not found::"+totalLiveFileEntryNotFound);
		logger.info("Total records with AssetEntry not found::"+totalAssetEntryNotFound);
		
		br.close();
    }catch(Exception e) {
	   out.println(e.getMessage());
	   logger.error(e.getMessage());
	}